/*
    RENDATE: rinomina il file o la cartella specificata, aggiungendo le
    informazioni relative alla data correte.
    
    Copyright (C) 2003 Fabio Baccolini

    Questo programma  software libero;  lecito redistribuirlo o
    modificarlo secondo i termini della Licenza Pubblica Generica GNU
    come  pubblicata dalla Free Software Foundation; o la versione 2
    della licenza o (a propria scelta) una versione successiva.

    Questo programma  distribuito nella speranza che sia utile, ma
    SENZA ALCUNA GARANZIA; senza neppure la garanzia implicita di
    NEGOZIABILIT o di APPLICABILIT PER UN PARTICOLARE SCOPO. Si
    veda la Licenza Pubblica Generica GNU per avere maggiori dettagli.

    Questo programma deve essere distribuito assieme ad una copia
    della Licenza Pubblica Generica GNU; in caso contrario, se ne pu
    ottenere una scrivendo alla Free Software Foundation, Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA


L'autore del software:

    Fabio Baccolini
    E-mail: fabio.baccolini@alice.it

*/

#pragma hdrstop
#include <condefs.h>

// Aggiunte da fabio
#include <string.h>
#include <dos.h>
#include <dir.h>
#include <stdio.h>
// Fine

//---------------------------------------------------------------------------
#pragma argsused

#define MaxStr 256 // Definisce le dimensioni massime di un vettore stringa
char oldname[MaxStr];
char newname[MaxStr];
char anno[MaxStr];
char mese[MaxStr];
char giorno[MaxStr];
struct date d;

void num2string(int num, char string[MaxStr]){
char aux[MaxStr];
int i=0;
int resto=0;
strcpy(string,"0");
while(num>0){
  resto=num%10;
  aux[i]=(unsigned char)('0' + resto);
  num=num/10;
  if(num==0) aux[i+1]='\0';
  i++;
  }
int len=strlen(aux);
for(int j=1; j<=len ;j++) string[j-1]=aux[len-j];
}

int main(int argc, char **argv){
if(argc!=2){
  printf("\n");
  printf("Copyright (C) 2003, Fabio Baccolini.\n\n");
  printf("'rendate' modifica il nome di un file o di una directory\n");
  printf("aggiungendo la data davanti al nome.\n");
  printf("\n");
  printf("rendate [file o directory]\n");
  printf("\n");
  printf("Esempi:\n");
  printf("rendate nomefile\n");
  printf("rendate \"nome del file\"\n");
  printf("rendate nomedirectory\n");
  printf("redate \"nome della directory\"\n");
  return 1;
  }

strcpy(oldname,argv[1]);

getdate(&d);
num2string(d.da_year,anno);
num2string(d.da_mon,mese);
num2string(d.da_day,giorno);
strcpy(newname, anno);
strcat(newname,"-");
if (d.da_mon<10) strcat(newname,"0");
strcat(newname, mese);
strcat(newname,"-");
if (d.da_day<10) strcat(newname,"0");
strcat(newname, giorno);
strcat(newname,"-");
strcat(newname,oldname);
int res=rename(oldname,newname);
if(res!=0){
  printf("\nErrore nell'esecuzione del comando:\n");
  if(errno==EEXIST) printf("esiste gia' un file che si chiama %s,\n",newname);
  if(errno==ENOENT) printf("il file %s non esiste,\n",oldname);
  printf("digita 'rendate' per ottenere aiuto.\n");
  return 1;
  }
printf("%s e' il nuovo nome del file.\n",newname);
return 0;
}
