/*
    HOSTINFO: questa utility visualizza il nome e gli indirizzi IP della
    macchina corrente.

    Copyright (C) 2003 Fabio Baccolini

    Questo programma  software libero;  lecito redistribuirlo o
    modificarlo secondo i termini della Licenza Pubblica Generica GNU
    come  pubblicata dalla Free Software Foundation; o la versione 2
    della licenza o (a propria scelta) una versione successiva.

    Questo programma  distribuito nella speranza che sia utile, ma
    SENZA ALCUNA GARANZIA; senza neppure la garanzia implicita di
    NEGOZIABILIT o di APPLICABILIT PER UN PARTICOLARE SCOPO. Si
    veda la Licenza Pubblica Generica GNU per avere maggiori dettagli.

    Questo programma deve essere distribuito assieme ad una copia
    della Licenza Pubblica Generica GNU; in caso contrario, se ne pu
    ottenere una scrivendo alla Free Software Foundation, Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA



L'autore del software:

    Fabio Baccolini
    E-mail: fabio.baccolini@alice.it

*/

#pragma hdrstop
#include <condefs.h>
//---------- AGGIUNTE DA FABIO
#include <windows.h>
#include <winsock2.h>
#include <stdio.h>

//---------------------------------------------------------------------------
#pragma argsused
int main(int argc, char **argv)
{
WORD wVersionRequested;
WSADATA wsaData;
int err;

wVersionRequested = MAKEWORD( 2, 0 );

err = WSAStartup( wVersionRequested, &wsaData );
if ( err != 0 ) {
    //Tell the user that we couldn't find a usable WinSock DLL.;
    printf("Errore d'inizializzazione di WinSock DLL.\n");
    return 1;
}

/* Confirm that the WinSock DLL supports 2.0.*/
/* Note that if the DLL supports versions greater    */
/* than 2.0 in addition to 2.0, it will still return */
/* 2.0 in wVersion since that is the version we      */

/* requested.                                        */

if ( LOBYTE( wsaData.wVersion ) != 2 ||
        HIBYTE( wsaData.wVersion ) != 0 ) {
    //Tell the user that we couldn't find a usable WinSock DLL.
    printf("Errore d'inizializzazione di WinSock DLL.\n");
    WSACleanup( );
    return 1;
}

/* The WinSock DLL is acceptable. Proceed. */

/*
struct hostent {
  char FAR *       h_name;
  char FAR * FAR * h_aliases;
  short            h_addrtype;
  short            h_length;
  char FAR * FAR * h_addr_list;
};
*/

char name[256];
int namelen=128;
int error=0;
hostent *h;

if(gethostname(name, namelen)!=0){
  printf("Impossibile individuare il nome dell'host.\n");
  error=1;
 }
else printf("Nome host: %s\n", name);

if( (h=gethostbyname(name))==NULL ){
   printf("Impossibile individuare le informazioni della macchina locale.\n");
   error=1;
 }
else{
  printf("Nome completo: %s\n",h->h_name);
  printf("Lista degli alias:");
  int i=0;
  while(h->h_aliases[i]!=NULL){
    printf(" %s",h->h_aliases[i]);
    i++;
   }
  if(i==0) printf(" nessun alias definito");
  printf("\n");
  printf("Tipo di indirizzi: %d\n",h->h_addrtype);
  printf("Lunghezza degli indirizzi: %d\n",gethostbyname(name)->h_length);
  i=0;
  printf("Lista degli indirizzi:");
  while(h->h_addr_list[i]!=NULL){
    int cifra=0;
    printf(" ");
    for(int j=0; j<h->h_length; j++){
      cifra = (255)&(h->h_addr_list[i][j]); //Conversione di formato
      printf("%i",cifra);
      if(j<(h->h_length-1)) printf(".");
     }
    i++;
   }
  if(i==0) printf(" nessun indirizzo definito");
  printf("\n");
 }
WSACleanup();
return error;
}

