/*
    DESCRIZIONE: libreria di uso comune per i programmi.
    
    Copyright (C) 2003 Fabio Baccolini

    Questa libreria  software libero;  lecito redistribuirla o
    modificarla secondo i termini della Licenza Pubblica Generica GNU
    come  pubblicata dalla Free Software Foundation; o la versione 2
    della licenza o (a propria scelta) una versione successiva.

    Questa libreria  distribuita nella speranza che sia utile, ma
    SENZA ALCUNA GARANZIA; senza neppure la garanzia implicita di
    NEGOZIABILIT o di APPLICABILIT PER UN PARTICOLARE SCOPO. Si
    veda la Licenza Pubblica Generica GNU per avere maggiori dettagli.

    Questa libreria deve essere distribuita assieme ad una copia
    della Licenza Pubblica Generica GNU; in caso contrario, se ne pu
    ottenere una scrivendo alla Free Software Foundation, Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA


L'autore del software:

    Fabio Baccolini
    E-mail: fabio.baccolini@alice.it

*/

/*
---------------------------------------------------------------------------
COLLEZIONE DI FUNZIONI E PROCEDURE

int NumToStr(int num, string str)
    Converte un numero intero positivo in una stringa.

int StrToNum(int *risultato, string str)
    Converte una stringa rappresentante un numero senza segno in un numero.

---------------------------------------------------------------------------
*/

#include <stdio.h>
#include <string.h>

#define TRUE 1
#define FALSE 0

const StrMax = 256;
typedef char string[StrMax];
typedef unsigned char byte; // 8 bit
typedef unsigned int word;  // 32 bit

/* Converte un numero intero positivo in una stringa.
   Valori restituiti: 0 successo, 1 errore (numero fornito negativo) */
int NumToStr(int num, string str){
if(num<0) return 1;
string aux;
int i=0;
int resto=0;
strcpy(str,"0");
while(num>0){
  resto=num%10;
  aux[i]=(unsigned char)('0'+resto);
  num=num/10;
  if(num==0) aux[i+1]='\0';
  i++;
  }
int len=strlen(aux);
for(int j=1; j<=len ;j++) str[j-1]=aux[len-j];
return 0;
}

/* Converte una stringa rappresentante un numero senza segno in un intero.
   Valori restituiti: 0=successo, 1=errore. */
int StrToNum(int *risultato, string str){
int num=*risultato; // Variabile interna per i calcoli
int cifre=strlen(str); // Numero di cifre del numero da convertire
int peso; // Peso di una cifra
int i;

// Verifica che la stringa non sia vuota
if(strlen(str)==0) return 1;

// Verifica che si tratti di un numero senza segno
i=0;
while(str[i]!='\0'){
  if( (str[i]<'0')||(str[i]>'9') ) return 1;
  i++;
 }

// Inizia la conversione
i=cifre-1;
peso=1;
num=0;
while(i>=0){
  num=num+(str[i]-'0')*peso;
  i--;
  peso=peso*10;
 }
*risultato=num;
return 0;
}
