/*
    DELAY: questa utility crea una pausa di attesa per un numero di secondi
    che vengono specificati come argomento del programma.
    
    Copyright (C) 2003 Fabio Baccolini

    Questo programma  software libero;  lecito redistribuirlo o
    modificarlo secondo i termini della Licenza Pubblica Generica GNU
    come  pubblicata dalla Free Software Foundation; o la versione 2
    della licenza o (a propria scelta) una versione successiva.

    Questo programma  distribuito nella speranza che sia utile, ma
    SENZA ALCUNA GARANZIA; senza neppure la garanzia implicita di
    NEGOZIABILIT o di APPLICABILIT PER UN PARTICOLARE SCOPO. Si
    veda la Licenza Pubblica Generica GNU per avere maggiori dettagli.

    Questo programma deve essere distribuito assieme ad una copia
    della Licenza Pubblica Generica GNU; in caso contrario, se ne pu
    ottenere una scrivendo alla Free Software Foundation, Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA


L'autore del software:

    Fabio Baccolini
    E-mail: fabio.baccolini@alice.it

*/

#pragma hdrstop
#include <condefs.h>

// Aggiunte da fabio
#include <string.h>
#include <time.h>
#include <stdio.h>
#include <conio.h>

#include "libreria.h"  // User-supplied include file
// Fine

#pragma argsused

int TempoDiPausa;  // Parametro [tempo]
int TempoTrascorso;
int TempoResiduo;
int TempoResiduoPrecedente;
time_t TempoIniziale;

int main(int argc, char **argv){
if(argc!=2){
  printf("\n");
  printf("Copyright (C) 2003, Fabio Baccolini.\n\n");
  printf("'delay' introduce una pausa per un numero di secondi specificato\n");
  printf("dal parametro [tempo].\n");
  printf("\n");
  printf("delay [tempo]\n");
  printf("\n");
  printf("Esempio: delay 5\n");
  return 1;
  }

// Conversione in formato numerico del parametro passato al programma
if(StrToNum(&TempoDiPausa,argv[1])){
  printf("Il numero di secondi non e' stato fornito in modo corretto.\n");
  return 1;
 }

// Effettua una prima misura del tempo trascorso:
// time, in seconds, elapsed since 00:00:00 GMT, January 1, 1970
TempoIniziale = time(NULL);
TempoResiduoPrecedente=-1; // Serve per forzare la prima volta la stampa video
do{
   TempoTrascorso=time(NULL)-TempoIniziale;
   // Le due seguenti righe di codice servono per fare in modo che il tempo
   // Residuo venga aggiornato sullo schermo solo se  cambiato
   TempoResiduo=TempoDiPausa-TempoTrascorso;
   if(TempoResiduoPrecedente!=TempoResiduo){
      if(TempoResiduo==1){
         printf("\r");
         printf("Attendere qualche istante (%d secondo)...",TempoResiduo);
         clreol();
       }
      else{
         printf("\r");
         printf("Attendere qualche istante (%d secondi)...",TempoResiduo);
         clreol();
       }
    }
   TempoResiduoPrecedente=TempoResiduo;
 }while(TempoTrascorso<TempoDiPausa);
printf("\n");
return 0;
}
