--
--
-- SHRINK TRANSACTION LOG
--
-- Compatta i log delle transazioni, riportandoli alla dimensione minima impostata,
-- per i database non di sistema e con recovery model full.
--
-- Microsoft SQL Server 2005 only, Fabio Baccolini (c) 2016.
--
--
DECLARE @DatabaseName varchar(100), @DatabaseLogFile varchar(100), @SqlStatement varchar(1024)
SET ROWCOUNT 1
SELECT @DatabaseName = name FROM sys.databases WHERE database_id > 4 AND recovery_model = 1 ORDER BY name
WHILE @@ROWCOUNT > 0
BEGIN
SELECT @DatabaseLogFile = name FROM sys.master_files WHERE type = 1 AND name LIKE ('%' + @DatabaseName + '%')
--
-- SQL statement to execute
SET @SqlStatement =  'USE [' + @DatabaseName + ']; CHECKPOINT;'
SELECT @SqlStatement = 'USE [' + @DatabaseName + ']; EXEC (''' + @SqlStatement + ''');'
PRINT (@SqlStatement)
EXEC (@SqlStatement)
--
-- SQL statement to execute
SET @SqlStatement = 'ALTER DATABASE ' + @DatabaseName + ' SET RECOVERY SIMPLE;'
SELECT @SqlStatement = 'USE [' + @DatabaseName + ']; EXEC (''' + @SqlStatement + ''');'
PRINT (@SqlStatement)
EXEC (@SqlStatement)
--
-- SQL statement to execute
SET @SqlStatement =  'USE [' + @DatabaseName + ']; CHECKPOINT;'
SELECT @SqlStatement = 'USE [' + @DatabaseName + ']; EXEC (''' + @SqlStatement + ''');'
PRINT (@SqlStatement)
EXEC (@SqlStatement)
--
-- SQL statement to execute
SET @SqlStatement = 'DBCC SHRINKFILE (' + @DatabaseLogFile + ') WITH NO_INFOMSGS;'
SELECT @SqlStatement = 'USE [' + @DatabaseName + ']; EXEC (''' + @SqlStatement + ''');'
PRINT (@SqlStatement)
EXEC (@SqlStatement)
--
-- SQL statement to execute
SET @SqlStatement =  'USE [' + @DatabaseName + ']; CHECKPOINT;'
SELECT @SqlStatement = 'USE [' + @DatabaseName + ']; EXEC (''' + @SqlStatement + ''');'
PRINT (@SqlStatement)
EXEC (@SqlStatement)
--
-- SQL statement to execute
SET @SqlStatement = 'ALTER DATABASE ' + @DatabaseName + ' SET RECOVERY FULL;'
SELECT @SqlStatement = 'USE [' + @DatabaseName + ']; EXEC (''' + @SqlStatement + ''');'
PRINT (@SqlStatement)
EXEC (@SqlStatement)
--
-- SQL statement to execute
SET @SqlStatement =  'USE [' + @DatabaseName + ']; CHECKPOINT;'
SELECT @SqlStatement = 'USE [' + @DatabaseName + ']; EXEC (''' + @SqlStatement + ''');'
PRINT (@SqlStatement)
EXEC (@SqlStatement)
--
SELECT @DatabaseName = name FROM sys.databases WHERE name > @DatabaseName AND database_id > 4 AND recovery_model = 1 ORDER BY name 
END 
SET ROWCOUNT 0
